

 
 /***************************************************************************************************************
  *                          Example_2. ET-REMOTE MP3 Trig-Mode By Check EOF Signal                                            *
  ***************************************************************************************************************
  *                                                                                                             *
  * Target MCU           : STM8S208MB(ET-BASE STM8S208)                                                         *
  *       	             : USE Internal Clock HSI: 16 MHz                                                       *                                                              
  *                                                                                                             *
  * Editor               : STD V4.1.5                                                                           *
  * Compiler             : COSMIC CXSTM8_16K V4.2.8                                                             *
  * Firmware library     : V1.1.1 update (06/05/2009)                                                           *
  *																				                                                                      *
  * Port Interface       :                                                                                      *
  *																											                                                        *
  *            I/O       : # MCU-STM8S208 #                 # ET-REMOTE MP3 #                                   *
  *                        ----------------                 -----------------                                   *
  *                                                                                                             *                                   
  *                        PB[0..7](OUT)       connect       Trig CH1-CH8                                       *                                        
  *                        PI[0..7](OUT)       connect       Trig CH9-CH16                                      *   
  *                        PG7(IN)             connect       EOF Terminal                           				    *	
  *                        GND                 connect       GND                                                *                                                           
  *                                                                                                    		      *
	*                 3.3V                                                              S1=OFF,S2=OFF             *
  *                 --+--                                                            -DIP-SW.CONFIG             *
  *                   |                                                                S1=OFF,S2=ON             *
  *                   |             																		                                        *
  *                   |                                                          --------------------			      *
  *             ------+------           Trig Signal CH1-CH8 (Active'0')         |                    |          *
  *            |         PB0 |--------------------------------------------------|CH1                 |          *
  *            |          .  |                                                  | .                  |          *
  *            |          .  |                                                  | .                  |          *
  *            |          .  |                                                  | .                  |          *
  *            |         PB7 |--------------------------------------------------|CH8                 |          *
  *            |             |                                                  |                    |          *
  *            |             |                                                  |   ET-REMOTE MP3V2  |          *
  *            |             |          Trig Signal CH9-CH16 (Active'0')        |                    |          *
  *            |         PI0 |--------------------------------------------------|CH9                 |          *
  *            |          .  |                                                  | .                  |          *
  *      +-----|PG7       .  |                                                  | .                  |          *
  *      |     |          .  |                                                  | .                  |          *
  *      |     |         PI7 |--------------------------------------------------|CH16       [Supply] |          *
  *      |      -----+-------                                                   |   EOF      G    5V |          *
  *      |           |STM8S208                                                   ----+-------+-----+-           *
  *      |         --+--                                                             |       |     |            *
  *      |          ---                                                              |       |     |            *
  *      |           -                                                               |       |     +-->5V       *
  *      +---------------------------------------------------------------------------+     --+--                *
  *                                                                                         ---                 *
  *                                                                                          -                  *
  * Operation            : Play File 1-16 By Trig Auto                                                          *
  *                                                                                                             *
  *                                                                                                             *
  * File Libary(src) Add :                                                                                      *
  *                        1. stm8s_gpio.c                                                                      *
  *                        2. stm8s_clk.c                                                                       *
	*                        3. stm8s_tim4.c                                                                      *
  *                                                                                                             *
  *                                                                                                             *
  * Create By            : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                 *
  * Last Update          : 11/June/2012                                                                         *
  *                                                                                                             *
  ***************************************************************************************************************/

 
#include "stm8s.h"
#include "stdio.h"
 
 unsigned int counter ;


/***************************************************
 *                   Function delay ms 		    	   *
 ***************************************************/

void delay (void)
{
	char i  ;
  for(i=0;i<2;i++){;} 
	  
}


void delay_ms(unsigned int ms)
{ 
	counter=0                     ;
	TIM4_Cmd(ENABLE)              ;     //Start Time4	
  while(counter!= ms){delay();}
	TIM4_Cmd(DISABLE)             ;    //Stop Time4	
	
}



/*************************************************************************
 *            Function Initial Timer4 Control for delay                  *
 *     Max CPU Freq = 16 MHz                                             *
 *     Prescaler to divide Fcpu by = 128                                 *
 *     Freq-Clock = 16MHz/128 =  0.125 MHz= 8 us/clock.                  *
 *************************************************************************/


//------------------------ Initial Timer4 For Delay Interrupt every 1 ms ----------------------

 void Init_Timer4(void)
  {
		TIM4_DeInit()                             ;   //clear overflow flag 
    TIM4_TimeBaseInit(TIM4_PRESCALER_128,125) ;   //Freq master/128 ,Perioid = 125x8us =1 ms
    TIM4_ITConfig(TIM4_IT_UPDATE,ENABLE)      ;   //Enable interrupt
		enableInterrupts()                     ;   // Enable general interrupts 
	}


 
 /***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
 {
	
	 GPIO_DeInit(GPIOB)                                          ;      //CLear PortB
	 GPIO_DeInit(GPIOI)                                          ;      //CLear PortI
	 GPIO_DeInit(GPIOG)                                          ;      //CLear PortG
	 
	 
	 GPIO_Init(GPIOB,GPIO_PIN_ALL,GPIO_MODE_OUT_PP_HIGH_FAST )   ;      //Initial PB = Output,Level High
	 GPIO_Init(GPIOI,GPIO_PIN_ALL,GPIO_MODE_OUT_PP_HIGH_FAST )   ;      //Initial PI = Output,Level Hugh
	 GPIO_Init(GPIOG,GPIO_PIN_7,GPIO_MODE_IN_PU_NO_IT)           ;      //Initial PG7 = Input,Pull up,No External INT.
	
 }
 

 
/************************************************************************
 *               Check Status Signal EOF : End OF File 				    *
 ************************************************************************/

void Chk_Eof(void)
{
  char eof ;
       
  do                                                 //Loop Check Eof = 0 :end file 
   {
     eof  =  GPIO_ReadInputPin(GPIOG,GPIO_PIN_7)  ;  //Read PG7 : 0 = end of message , 1 = Ready for Play or Playing  
    
   }while(eof == 0x80)                            ;  //eof = 0 exit loop
    
  do                                                 //Loop Check Eof = 1 : Ready 
   {
     eof  =  GPIO_ReadInputPin(GPIOG,GPIO_PIN_7)  ;  //Read PG7 : 0 = end of message , 1 = Ready for Play or Playing  
   }while(eof == 0)                               ;  //eof = 1 exit loop
}



 /************************************************************
  **                                                        **
  **      Function Play File CH1-CH16(Trig Active 0)        **
  **                                                        **
  ************************************************************/ 


void Play_File(void)
{  
  char bt,bi=0xFE,del=0x01 ;
  
    //--------------- PB[0..7] TRIG CH[1..8]-------------

  for(bt=0;bt<8;bt++)              //Loop Control Port bit for Trig Next File
   {                   
     GPIO_Write(GPIOB,bi)      ;   //Port_PB_Bit(x)=0 : Trig-CH(x+1)   

     delay_ms(20)              ;   //Delay 20 ms for Trig 0

     GPIO_Write(GPIOB,0xFF)    ;   //Port_PB_Bit(All)= 1  

     Chk_Eof()                 ;   //Check Play End File
       
     bi = bi-del               ;    //Mark bit x = 0 (x=0-7)
     del= del << 1             ;    //Value for use Mark bit 
  
   }

    //--------------- PI[0..7] TRIG CH[9..16]-------------
    
  bi  = 0xFE                 ;    //Initial Start Mark bit0 =0
  del = 0x01                 ;    //Initial value mark bit =1

  for(bt=0;bt<8;bt++)             //Loop Control Port bit for Trig Next File
   {                     
		 GPIO_Write(GPIOI,bi)    ;    //Port_PI_Bit(x)=0 : Trig-CH(x+9)   

     delay_ms(20)            ;    //Delay 20 ms for Trig 0
 
		 GPIO_Write(GPIOI,0xFF)  ;    //Port_PI_Bit(ALL)=1  
 
     Chk_Eof()               ;    //Check Play End File
        
     bi = bi-del             ;    //Mark bit x = 0 (x=0-7)
     del= del << 1           ;    //Value for use Mark bit 
    
   }
}


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 main(void) 
  {

    Init_Port()        ;
    Init_Timer4()      ;

    delay_ms(1000)     ;   //delay for Sync Borad MP3 Ready 

    while(1)
     {
       delay_ms(500)   ;
       Play_File()     ;   //Sen Signal Trig Start Play File CH1  
     }   
  }






#ifdef USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param file: pointer to the source file name
  * @param line: assert_param error line source number
  * @retval : None
  */
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif






